//Dustin Soodak

#ifndef MISC_HARDWARE_H
#define MISC_HARDWARE_H

#include <Adafruit_NeoPixel.h>
#include "Pitches.h"


// ***************************************************
// Pin defines
// ***************************************************

//
#define Accel_Interrupt 2 //used by both Gyro and Accel chips.
#define Accel_Interrupt_Num 0 //pin2 is interrupt 0 on arduino uno board
#define MotorDirection_Right 1
#define MotorDirection_Left 0
#define MotorDrive_Left 6
#define MotorDrive_Right 5
//
#define Chirp 9 //tone(pin, frequency) and noTone(),  or tone(pin, frequency, duration). also look at toneAC library
#define Edge_Lights 8 //turn on IR_FRNT_LEFT_BTM and IR_FRNT_RGHT_BTM
#define _38kHz_Rx 3
#define LightSense_Rear 3 //AD3
#define Source_Select 4 
#define LightSense_Left 2 //AD2 //Source_Select LOW=AMB_FRNT_LEFT, HIGH=EDGE_FRNT_LEFT
#define LightSense_Right 1 //AD1 //Source_Select LOW=AMB_FRNT_RIGHT, HIGH=EDGE_FRNT_RIGHT
#define MotorCapBattVolts 0 //AD0 //Source_Select LOW=motor capacitor, HIGH=battery
//
#define IR_Enable_Front 13
#define IR_Enable_RearLeft 12
#define IR_Enable_RearRight 11
#define IR_Send 10
//
#define Light_Bus_BTN1 7 //for 6 neo pixel RGB

// ***************************************************
// end Pin defines
// ***************************************************

// ***************************************************
// General hardware
// ***************************************************
#define SERIAL_SPEED 38400
extern void HardwareBegin(void);
extern void SwitchButtonToPixels(void);
extern void SwitchPixelsToButton(void);
extern void SwitchSerialToMotors(void);
extern void SwitchMotorsToSerial(void);
extern char ButtonPressed(void);
// ***************************************************
// end General hardware
// ***************************************************

// ***************************************************
// Simple Timer
// ***************************************************
  extern int32_t GetTime(void);
  extern void RestartTimer(void);
  extern void StopTimer(void);
// ***************************************************
// end Simple Timer
// ***************************************************


// ***************************************************
// Pixels
// ***************************************************
#define NUM_PIXELS 6
extern void SetPixelRGB(int Pixel, int Red, int Green, int Blue);
extern void SetAllPixelsRGB(int Red, int Green, int Blue);
extern void RefreshPixels(void);
//
//low level/misc:
//
extern Adafruit_NeoPixel pixels;// = Adafruit_NeoPixel(NUM_PIXELS, Light_Bus_BTN1, NEO_GRB + NEO_KHZ800);
#define H_Bright 50 //headlight brightness used in some examples
#define M_Bright 50 //moodlighting brightness used in some examples
// ***************************************************
// end Pixels
// ***************************************************


// ***************************************************
// Chirp
// ***************************************************
extern void PlayChirp(unsigned int Frequency, unsigned int Amplitude);//Amplitude: 0-50 (50 gives max voltage of 17: hardware to be tuned better later)
extern void PlayAnger(void);
extern void PlayBoredom(void);
extern void PlayExcited(void);
//  PlayChirp(NOTE_G5,30);
//  delay(200);
//  PlayChirp(NOTE_C6,40);
// ***************************************************
// end Chirp
// ***************************************************

// ***************************************************
// Motor
// ***************************************************
#define MOTOR_MAX 255
extern int LeftMotor;
extern int RightMotor;
extern void MotorsBegin(void);
extern void Motors(int LeftMotorSpeed, int RightMotorSpeed);//negative values to make it go backwards
// ***************************************************
// end Motor
// ***************************************************


// ***************************************************
// Movement functions
// ***************************************************
extern void MoveXYWithOptions(int X, int Y, int Speed, int MaxExpectedRunTime, int MaxExpectedSkidTime, void (*EdgeFunction)(char), char Wiggle);
extern void MoveWithOptions(int Direction, int Speed, int Distance, int MaxExpectedRunTime, int MaxExpectedSkidTime, 
                                    void (*EdgeFunction)(char), char Wiggle);//50 is about medium wiggle
extern char RotateAccurate(int Heading, int MaxExpectedTurnTime);
extern void RotateSimple(int TurnDegrees, int left, int right, int MaxExpectedTurnTime, int MaxExpectedSkidTime);
// ***************************************************
// end Movement functions
// ***************************************************


// ***************************************************
// random examples and obsolete movement functions
// ***************************************************

//extern void MoveStraight(int Speed, int ms, int MaxExpectedSkidTime);
extern void MoveStraight(int Direction, int Speed, int Distance, int MaxExpectedRunTime, int MaxExpectedSkidTime);//Distance=0 to just go for MaxExpectedRunTime
extern void MoveStraightWithFullOptions(int Direction, int Speed, int Distance, int MaxExpectedRunTime, int MaxExpectedSkidTime, void (*EdgeFunction)(char), 
                                    int PIDRange, float ProportionalTerm, float IntegralTerm, float DerivativeTerm);
extern void ExploreExample(int Speed, unsigned int MaxExpectedRunTimeSec, int MaxExpectedSkidTimeMs);
extern void MaintainPositionExample(void);
// ***************************************************
// random examples and obsolete movement functions
// ***************************************************



// ***************************************************
// IR
// ***************************************************
extern void TxIR(char *Data, int Length);
//
extern void RxIRStop(void);
extern void RxIRRestart(void);
extern char IsIRDone(void);
extern char IRNumOfBytes;
//
extern void IRMenuTest(void);
//
//Low level:
//
extern int IRTransitionCount;
extern unsigned char IRBytes[20];
extern char IRActive;
extern volatile char IRReceiving;//note: IRReceiving turned off if IsIRDone() in regular or auto NavigationHandler() and causes ReadSideSensors() to repeat
//
extern void PlayChirpIR(unsigned int Frequency, unsigned int DutyCycle);//PlayChirpIR(38000,6) seems to produce best square wave.
extern void ModulateIR(char Level);
//
extern void IRHandler(void);
//
// ***************************************************
// end IR
// ***************************************************

// ***************************************************
// Light & Edge Sensing
// ***************************************************
//
extern void ReadSideSensors(void);//single relative & ambient reading from each of the 3 side sensors (pauses and/or repeats if IRReceiving)
extern int RightLightLevel,LeftLightLevel,RearLightLevel;
extern int RearAmbientLightLevel,RightAmbientLightLevel,LeftAmbientLightLevel;
//
extern void ReadEdgeLightSensors(char Averages);//averages 8 reads
extern int RightEdgeLightLevel,LeftEdgeLightLevel;
//
extern void ResetLookAtEdge(void);//reset edge runnning average
extern void LookAtEdge(void);//take readings and add to running average
extern int LeftEdgeSensorAverage,RightEdgeSensorAverage;
extern int LeftEdgeSensorValue,RightEdgeSensorValue;
extern char LookForEdge(void);//calls LookAtEdge(), then uses running average to detect edges
//
//Low level:
//
extern void EdgeLightsOn(void);
extern void EdgeLightsOff(void);
//
extern void SwitchAmbientToEdge(void);
extern void SwitchEdgeToAmbient(void);
//
extern int ReadLeftLightSensor(void);
extern int ReadRightLightSensor(void);
extern int ReadBackLightSensor(void);
//
//
// ***************************************************
// end Light & Edge Sensing
// ***************************************************



















//

// ***************************************************
// end Misc Hardware
// ***************************************************







/*ReadSideSensors

 
  //clear pixels and blink the first one blue
  SwitchButtonToPixels();  
  SetAllPixelsRGB(0,0,0);
  SetPixelRGB(0,0,0,255);
  RefreshPixels();
  delay(100);
  SetPixelRGB(0,0,0,0);
  RefreshPixels();
  //read light levels till button pressed
  EdgeLightsOn();
  SwitchAmbientToEdge();
  SwitchMotorsToSerial();
  SwitchPixelsToButton();
  while(!ButtonPressed()){
    delay(100);
    Serial.print("left: ");
    Serial.print(ReadLeftLightSensor(),DEC);
    Serial.print(" right: ");
    Serial.println(ReadRightLightSensor(),DEC);
  } 
  EdgeLightsOff();
  //wait till button released then wait 1 second
  delay(10);
  while(ButtonPressed()); 
  delay(1000);
  //init and pause navigation
  NavigationBegin();
  PauseNavigation();
  //move as commanded
  RotateSimple(180, 100, -100, 1000, 500);//rotate 180 degrees to the right at speed 100, for max of 1000ms and keep updating position for 500ms more.
  MoveStraight(200, 600, 5000, 500);//move at speed 200 for 600mm(about 2 ft), for max of 5000ms and keep updating position for 500ms more.
    
  
*/





#endif
